;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NSIS installer script for vlc ;
; (http://nsis.sourceforge.net) ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

!define PRODUCT_NAME "VLC media player"
!define VERSION 3.0.13
!define PRODUCT_VERSION 3.0.13
!define PRODUCT_GROUP "VideoLAN"
!define PRODUCT_PUBLISHER "VideoLAN"
!define PRODUCT_WEB_SITE "https://www.videolan.org/"
!define PRODUCT_DIR_REGKEY "Software\VideoLAN\VLC"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_ID "{ea92ef52-afe4-4212-bacb-dfe9fca94cd6}"

!define MUI_LANGDLL_REGISTRY_ROOT "HKLM"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_DIR_REGKEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "Language"

!define MEMENTO_REGISTRY_ROOT ${PRODUCT_UNINST_ROOT_KEY}
!define MEMENTO_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"

# !define VLC_64BIT_INSTALLER

ManifestDPIAware true
Unicode true

!define INSTALL_ACTIVEX
!define INSTALL_MOZILLA

Var ReinstallType
Var ReinstallUninstallBtn
Var PerformUpdate
Var PreviousVersion
Var PreviousVersionState
Var PreviousInstallDir
Var UninstallLog

Var 32bitUninstaller
Var 32bitPath

;;;;;;;;;;;;;;;;;;;;;;;;;
; General configuration ;
;;;;;;;;;;;;;;;;;;;;;;;;;

Name "${PRODUCT_NAME}"
 OutFile ..\vlc-${VERSION}-win32.exe
#  OutFile ..\vlc-${VERSION}-win64.exe
InstallDir "$PROGRAMFILES\VideoLAN\VLC"
!ifdef NSIS_LZMA_COMPRESS_WHOLE
SetCompressor lzma
!else
SetCompressor /SOLID lzma
!endif

SetOverwrite ifdiff
CRCCheck on
BrandingText "${PRODUCT_GROUP} ${PRODUCT_NAME}"

InstType "$(Name_InstTypeRecommended)"
InstType "$(Name_InstTypeMinimum)"
InstType "$(Name_InstTypeFull)"

RequestExecutionLevel admin
!addincludedir NSIS
!addplugindir NSIS
!include nsProcess.nsh
!include WinVer.nsh
!include FileFunc.nsh
!include MUI2.nsh
!include Memento.nsh

!insertmacro GetParameters
!insertmacro GetOptions

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NSIS Modern User Interface configuration ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; MUI Settings
  !define MUI_ABORTWARNING
  !define MUI_ICON "vlc.ico"
  !define MUI_UNICON "vlc.ico"
  !define MUI_COMPONENTSPAGE_SMALLDESC

  ; Banner (welcome and finish page) for installer
  !define MUI_WELCOMEFINISHPAGE_BITMAP "NSIS/vlc_branding.bmp"
  ; Banner for uninstaller
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "NSIS/vlc_branding.bmp"

; Installer pages
  ; Welcome page
    !define MUI_PAGE_CUSTOMFUNCTION_PRE PageFastUpdatePre
    !define MUI_WELCOMEPAGE_TITLE_3LINES
    !insertmacro MUI_PAGE_WELCOME
  ; Optional update page
    Page custom PageReinstall PageLeaveReinstall
  ; License page
    !define MUI_LICENSEPAGE_BUTTON $(^NextBtn)
    !define MUI_LICENSEPAGE_TEXT_BOTTOM "$(License_NextText)"
    !define MUI_PAGE_CUSTOMFUNCTION_PRE PageSkipPre
    !insertmacro MUI_PAGE_LICENSE "COPYING.txt"
  ; Components page
    !define MUI_PAGE_CUSTOMFUNCTION_PRE PageComponentsPre
    !insertmacro MUI_PAGE_COMPONENTS
  ; Directory page
    !define MUI_PAGE_CUSTOMFUNCTION_PRE PageDirectoryPre
    !insertmacro MUI_PAGE_DIRECTORY
  ; Instfiles page
    !insertmacro MUI_PAGE_INSTFILES
  ; Finish page
    !define MUI_PAGE_CUSTOMFUNCTION_PRE PageFastUpdatePre
    !define MUI_FINISHPAGE_RUN
    !define MUI_FINISHPAGE_RUN_FUNCTION AppExecAs
    !define MUI_FINISHPAGE_LINK "$(Link_VisitWebsite)"
    !define MUI_FINISHPAGE_LINK_LOCATION "https://www.videolan.org/vlc/"
    !define MUI_FINISHPAGE_NOREBOOTSUPPORT
    !insertmacro MUI_PAGE_FINISH

; Uninstaller pages
    !insertmacro MUI_UNPAGE_CONFIRM
    !insertmacro MUI_UNPAGE_COMPONENTS
    !insertmacro MUI_UNPAGE_INSTFILES
    !insertmacro MUI_UNPAGE_FINISH

  !addincludedir "languages"
  !define VLC_LANGFILE_FALLBACK "EnglishExtra.nsh"

; Language files (first language is default)
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro LANGFILE_INCLUDE "EnglishExtra.nsh"

  !insertmacro MUI_LANGUAGE "French"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "FrenchExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "German"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "GermanExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Spanish"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "SpanishExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "SimpChinese"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "SimpChineseExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "TradChinese"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "TradChineseExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Japanese"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "JapaneseExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Italian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "ItalianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Dutch"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "DutchExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Danish"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "DanishExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Swedish"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "SwedishExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Finnish"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "FinnishExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Russian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "RussianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Portuguese"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "PortugueseExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "PortugueseBR"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "PortugueseBRExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Welsh"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "WelshExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Uzbek"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "UzbekExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Ukrainian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "UkrainianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Turkish"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "TurkishExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Thai"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "ThaiExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Norwegian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "NorwegianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Malay"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "MalayExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Korean"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "KoreanExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Greek"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "GreekExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Czech"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "CzechExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Bosnian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "BosnianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Arabic"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "ArabicExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Polish"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "PolishExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Romanian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "RomanianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Slovak"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "SlovakExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Serbian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "SerbianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Hungarian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "HungarianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Catalan"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "CatalanExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Bulgarian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "BulgarianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Estonian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "EstonianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Lithuanian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "LithuanianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Basque"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "BasqueExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Galician"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "GalicianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Hebrew"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "HebrewExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Slovenian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "SlovenianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Afrikaans"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "AfrikaansExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Albanian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "AlbanianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Croatian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "CroatianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Icelandic"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "IcelandicExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Latvian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "LatvianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Indonesian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "IndonesianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "ScotsGaelic"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "ScotsGaelicExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Breton"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "BretonExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "NorwegianNynorsk"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "NorwegianNynorskExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Asturian"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "AsturianExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Corsican"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "CorsicanExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Hindi"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "HindiExtra.nsh" ${VLC_LANGFILE_FALLBACK}
  !insertmacro MUI_LANGUAGE "Vietnamese"
  !insertmacro LANGFILE_INCLUDE_WITHDEFAULT "VietnameseExtra.nsh" ${VLC_LANGFILE_FALLBACK}

; Reserve files for solid compression
  !insertmacro MUI_RESERVEFILE_LANGDLL

;;;;;;;;;;;;;;;;;;;;;;;
; Macro and Functions ;
;;;;;;;;;;;;;;;;;;;;;;;

!include helpers\extensions.nsh
!include helpers\install.nsh
!include helpers\utils.nsh

;;;;;;;;;;;;;;;;;;;;;;
; Installer sections ;
; The CORE of the    ;
; installer          ;
;;;;;;;;;;;;;;;;;;;;;;

${MementoSection} "$(Name_Section01)" SEC01
  SectionIn 1 2 3 RO
  SetShellVarContext all
  SetOutPath "$INSTDIR"

  DetailPrint "$(Detail_CheckProcesses)"
  Call CheckRunningProcesses

  ; Remove 32 bit version first
  !ifdef VLC_64BIT_INSTALLER
  ${If} $32bitPath != ""
    ; Run uninstaller
    ClearErrors
    ExecWait '"$32bitUninstaller" /S _?=$32bitPath'

    ; If uninstall was not successfull, do not continue.
    ; This happens for example if the user cancels the uninstaller.
    ${If} ${Errors}
      Goto skip_uninstall32_cleanup
    ${EndIf}

    ${If} ${FileExists} "$32bitUninstaller"
      Delete "$32bitUninstaller"
      RMDir "$32bitPath"
    ${EndIf}
  ${EndIf}
  !endif

skip_uninstall32_cleanup:

  ; Remove previous version first, if this is update
  ${If} $ReinstallType == "1"
    FileOpen $UninstallLog "$INSTDIR\uninstall.log" r
    UninstallLoop:
      ClearErrors
      FileRead $UninstallLog $R0
      IfErrors UninstallEnd
      Push $R0
      Call TrimNewLines
      Pop $R0
      Delete "$INSTDIR\$R0"
      Goto UninstallLoop
    UninstallEnd:
    FileClose $UninstallLog
    Delete "$INSTDIR\uninstall.log"
    Delete "$INSTDIR\uninstall.exe"
    Push "\"
    Call RemoveEmptyDirs
  ${EndIf}

  !insertmacro OpenUninstallLog

  ; VLC.exe, libvlc.dll
  !insertmacro InstallFile vlc.exe
  !insertmacro InstallFile vlc-cache-gen.exe

  ; All dlls
  !insertmacro InstallFile *.dll

  ; Text files
  !insertmacro InstallFile *.txt

  ; Subfolders
  !insertmacro InstallFolder plugins
  !insertmacro InstallFolderOptional locale
  !insertmacro InstallFolder hrtfs
   !insertmacro InstallFolder skins
     !insertmacro InstallFolder lua

  ; Generate the cache and add it to uninstall.log
  nsExec::ExecToStack '"$INSTDIR\vlc-cache-gen.exe" $INSTDIR\plugins'
  FindFirst $0 $1 "$INSTDIR\plugins\*.dat"
  FileWrite $UninstallLog "plugins\$1$\r$\n"
  FindClose $0


  ; URLs
  WriteIniStr "$INSTDIR\${PRODUCT_GROUP} Website.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  FileWrite $UninstallLog "${PRODUCT_GROUP} Website.url$\r$\n"
  WriteIniStr "$INSTDIR\Documentation.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}/doc/"
  FileWrite $UninstallLog "Documentation.url$\r$\n"
  WriteIniStr "$INSTDIR\New_Skins.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}/vlc/skins.php"
  FileWrite $UninstallLog "New_Skins.url$\r$\n"

  !insertmacro CloseUninstallLog

  ; Add VLC to "recommended programs" for the following extensions
  WriteRegStr HKCR Applications\vlc.exe "" ""
  WriteRegStr HKCR Applications\vlc.exe "FriendlyAppName" "VLC media player"
  WriteRegStr HKCR Applications\vlc.exe\shell\Open "" "$(ContextMenuEntry_PlayWith)"
  WriteRegStr HKCR Applications\vlc.exe\shell\Open\command "" '"$INSTDIR\vlc.exe" --started-from-file "%1"'
  !insertmacro MacroAllExtensions RegisterExtensionMacro
  !insertmacro MacroSkinExtensions RegisterSkinExtensionMacro

  ; Add VLC to "App Paths" to run VLC from ShellExecute/ShellExecuteEx/run dialog without giving a full path
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\App Paths\vlc.exe" "" "$INSTDIR\vlc.exe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\App Paths\vlc.exe" "Path" "$INSTDIR"

  ; Windows default programs Registration
  ; Vista and above detection
  ${If} ${AtLeastWinVista}
    WriteRegStr HKLM "Software\RegisteredApplications" "VLC" "Software\Clients\Media\VLC\Capabilities"
    WriteRegStr HKLM "Software\Clients\Media\VLC\Capabilities" "ApplicationName" "VLC media player"
    WriteRegStr HKLM "Software\Clients\Media\VLC\Capabilities" "ApplicationDescription" "VLC - The video swiss knife"
    WriteRegStr HKLM "Software\Clients\Media\VLC" "" "VLC media player"
    WriteRegStr HKLM "Software\Clients\Media\VLC\InstallInfo" "HideIconsCommand" "$\"$INSTDIR\spad-setup.exe$\" /HideIcons /S"
    WriteRegStr HKLM "Software\Clients\Media\VLC\InstallInfo" "ShowIconsCommand" "$\"$INSTDIR\spad-setup.exe$\" /ShowIcons /S"
    WriteRegStr HKLM "Software\Clients\Media\VLC\InstallInfo" "ReinstallCommand" "$\"$INSTDIR\spad-setup.exe$\" /Reinstall /S"
    WriteRegDWORD HKLM "Software\Clients\Media\VLC\InstallInfo" "IconsVisible" 0x001
  ${EndIf}
${MementoSectionEnd}

${MementoSection} "$(Name_Section02a)" SEC02a
  SectionIn 1 2 3
  CreateDirectory "$SMPROGRAMS\VideoLAN"
  CreateShortCut "$SMPROGRAMS\VideoLAN\VLC media player.lnk" \
    "$INSTDIR\vlc.exe" ""
  CreateShortCut "$SMPROGRAMS\VideoLAN\VLC media player skinned.lnk" \
    "$INSTDIR\vlc.exe" "-Iskins"
  CreateShortCut "$SMPROGRAMS\VideoLAN\Documentation.lnk" \
    "$INSTDIR\Documentation.url"
  CreateShortCut "$SMPROGRAMS\VideoLAN\Release Notes.lnk" \
    "$INSTDIR\NEWS.txt" ""
  CreateShortCut "$SMPROGRAMS\VideoLAN\${PRODUCT_GROUP} Website.lnk" \
    "$INSTDIR\${PRODUCT_GROUP} Website.url"
  CreateShortCut "$SMPROGRAMS\VideoLAN\VLC media player - reset preferences and cache files.lnk" \
    "$INSTDIR\vlc.exe" "--reset-config --reset-plugins-cache vlc://quit"
${MementoSectionEnd}

${MementoSection} "$(Name_Section02b)" SEC02b
  SectionIn 1 2 3
  CreateShortCut "$DESKTOP\VLC media player.lnk" \
    "$INSTDIR\vlc.exe" ""
${MementoSectionEnd}

SectionGroup /e "!$(Name_Section34)"
!ifdef INSTALL_MOZILLA
${MementoSection} "$(Name_Section03)" SEC03
  SectionIn 1 3

  SetOutPath "$INSTDIR"
  !insertmacro OpenUninstallLog
  !insertmacro InstallFile npvlc.dll
  !insertmacro CloseUninstallLog

  !define Moz "SOFTWARE\MozillaPlugins\@videolan.org/vlc,version=${VERSION}"
  WriteRegStr HKLM ${Moz} "Description" "VLC Multimedia Plugin"
  WriteRegStr HKLM ${Moz} "Path" "$INSTDIR\npvlc.dll"
  WriteRegStr HKLM ${Moz} "Product" "VLC media player"
  WriteRegStr HKLM ${Moz} "Vendor" "VideoLAN"
  WriteRegStr HKLM ${Moz} "Version" "${VERSION}"
${MementoSectionEnd}
!endif

!ifdef INSTALL_ACTIVEX
${MementoSection} "$(Name_Section04)" SEC04
  SectionIn 1 3

  SetOutPath "$INSTDIR"
  !insertmacro OpenUninstallLog
  !insertmacro InstallFile axvlc.dll
  !insertmacro CloseUninstallLog
 RegDLL "$INSTDIR\axvlc.dll"
#  ExecWait 'regsvr32.exe /s "$INSTDIR\axvlc.dll"'
${MementoSectionEnd}
!endif
SectionGroupEnd


${MementoSection} "$(Name_Section05)" SEC05
  SectionIn 1 2 3
  WriteRegStr HKCR "AudioCD\shell\PlayWithVLC" "" "$(ContextMenuEntry_PlayWith)"
  WriteRegStr HKCR "AudioCD\shell\PlayWithVLC\command" "" \
    '"$INSTDIR\vlc.exe" --started-from-file cdda:///%1'
  WriteRegStr HKCR "DVD\shell\PlayWithVLC" "" "$(ContextMenuEntry_PlayWith)"
  WriteRegStr HKCR "DVD\shell\PlayWithVLC\command" "" \
    '"$INSTDIR\vlc.exe" --started-from-file dvd:///%1'

  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayDVDMovieOnArrival" "VLCPlayDVDMovieOnArrival" ""
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDMovieOnArrival" "Action" "$(Action_OnArrivalDVD)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDMovieOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDMovieOnArrival" "InvokeProgID" "VLC.DVDMovie"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDMovieOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDMovieOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayCDAudioOnArrival" "VLCPlayCDAudioOnArrival" ""
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayCDAudioOnArrival" "Action" "$(Action_OnArrivalAudioCD)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayCDAudioOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayCDAudioOnArrival" "InvokeProgID" "VLC.CDAudio"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayCDAudioOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayCDAudioOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayVideoCDMovieOnArrival" "VLCPlayVCDMovieOnArrival" ""
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVCDMovieOnArrival" "Action" "$(Action_OnArrivalVCDMovie)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVCDMovieOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVCDMovieOnArrival" "InvokeProgID" "VLC.VCDMovie"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVCDMovieOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVCDMovieOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlaySuperVideoCDMovieOnArrival" "VLCPlaySVCDMovieOnArrival" ""
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlaySVCDMovieOnArrival" "Action" "$(Action_OnArrivalSVCDMovie)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlaySVCDMovieOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlaySVCDMovieOnArrival" "InvokeProgID" "VLC.SVCDMovie"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlaySVCDMovieOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlaySVCDMovieOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayDVDAudioOnArrival" "VLCPlayDVDAudioOnArrival" ""
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDAudioOnArrival" "Action" "$(Action_OnArrivalDVDAudio)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDAudioOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDAudioOnArrival" "InvokeProgID" "VLC.OPENFolder"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDAudioOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDAudioOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayVideoFilesOnArrival" "VLCPlayVideoFilesOnArrival" ""
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVideoFilesOnArrival" "Action" "$(Action_OnArrivalVideoFiles)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVideoFilesOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVideoFilesOnArrival" "InvokeProgID" "VLC.OPENFolder"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVideoFilesOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVideoFilesOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayMusicFilesOnArrival" "VLCPlayMusicFilesOnArrival" ""
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayMusicFilesOnArrival" "Action" "$(Action_OnArrivalMusicFiles)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayMusicFilesOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayMusicFilesOnArrival" "InvokeProgID" "VLC.OPENFolder"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayMusicFilesOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayMusicFilesOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayBlurayOnArrival" "VLCPlayBlurayOnArrival" ""
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayBlurayOnArrival" "Action" "$(Action_OnArrivalBluray)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayBlurayOnArrival" "DefaultIcon" '"$INSTDIR\vlc.exe",0'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayBlurayOnArrival" "InvokeProgID" "VLC.Bluray"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayBlurayOnArrival" "InvokeVerb" "Open"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayBlurayOnArrival" "Provider" "VideoLAN VLC media player"

  WriteRegStr HKCR "VLC.DVDMovie" "" "VLC DVD Movie"
  WriteRegStr HKCR "VLC.DVDMovie\shell" "" "Open"
  WriteRegStr HKCR "VLC.DVDMovie\shell\Open\command" "" \
    '"$INSTDIR\vlc.exe" --started-from-file dvd:///%1'
  WriteRegStr HKCR "VLC.DVDMovie\DefaultIcon" "" '"$INSTDIR\vlc.exe",0'

  WriteRegStr HKCR "VLC.CDAudio" "" "VLC CD Audio"
  WriteRegStr HKCR "VLC.CDAudio\shell" "" "Open"
  WriteRegStr HKCR "VLC.CDAudio\shell\Open\command" "" \
    '"$INSTDIR\vlc.exe" --started-from-file cdda:///%1'
  WriteRegStr HKCR "VLC.CDAudio\DefaultIcon" "" '"$INSTDIR\vlc.exe",0'

  WriteRegStr HKCR "VLC.VCDMovie" "" "VLC VCD Movie"
  WriteRegStr HKCR "VLC.VCDMovie\shell" "" "Open"
  WriteRegStr HKCR "VLC.VCDMovie\shell\Open\command" "" \
     '"$INSTDIR\vlc.exe" --started-from-file vcd:///%1'
  WriteRegStr HKCR "VLC.VCDMovie\DefaultIcon" "" '"$INSTDIR\vlc.exe",0'

  WriteRegStr HKCR "VLC.SVCDMovie" "" "VLC SVCD Movie"
  WriteRegStr HKCR "VLC.SVCDMovie\shell" "" "Open"
  WriteRegStr HKCR "VLC.SVCDMovie\shell\Open\command" "" \
     '"$INSTDIR\vlc.exe" --started-from-file vcd:///%1'
  WriteRegStr HKCR "VLC.SVCDMovie\DefaultIcon" "" '"$INSTDIR\vlc.exe",0'

  WriteRegStr HKCR "VLC.OPENFolder" "" "VLC Play content"
  WriteRegStr HKCR "VLC.OPENFolder\shell" "" "Open"
  WriteRegStr HKCR "VLC.OPENFolder\shell\Open\command" "" \
     '"$INSTDIR\vlc.exe" %1'
  WriteRegStr HKCR "VLC.OPENFolder\DefaultIcon" "" '"$INSTDIR\vlc.exe",0'

  WriteRegStr HKCR "VLC.Bluray" "" "VLC Bluray"
  WriteRegStr HKCR "VLC.Bluray\shell" "" "Open"
  WriteRegStr HKCR "VLC.Bluray\shell\Open\command" "" \
    '"$INSTDIR\vlc.exe" --started-from-file bluray:///%1'
  WriteRegStr HKCR "VLC.Bluray\DefaultIcon" "" '"$INSTDIR\vlc.exe",0'

${MementoSectionEnd}


SectionGroup /e "!$(Name_Section06)" SEC06
  SectionGroup "$(Name_SectionGroupAudio)"
    !insertmacro MacroAudioExtensions AssociateExtensionSection
  SectionGroupEnd
  SectionGroup "$(Name_SectionGroupVideo)"
    !insertmacro MacroVideoExtensions AssociateExtensionSection
  SectionGroupEnd
  SectionGroup "$(Name_SectionGroupOther)"
    !insertmacro MacroOtherExtensions AssociateExtensionSection
    !insertmacro MacroSkinExtensions AssociateSkinExtensionSection
    !insertmacro MacroUnassociatedExtensions AssociateExtensionUnselectedSection
  SectionGroupEnd
SectionGroupEnd

${MementoSection} "$(Name_Section07)" SEC07
  SectionIn 1 3
  !insertmacro MacroAllExtensions AddContextMenu
  !insertmacro AddContextMenuExt "Directory"
${MementoSectionEnd}

${MementoUnselectedSection} "$(Name_Section08)" SEC08
  !insertmacro delprefs
${MementoSectionEnd}

${MementoSectionDone}

; Installer section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "$(Desc_Section01)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02a} "$(Desc_Section02a)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02b} "$(Desc_Section02b)"
!ifdef INSTALL_MOZILLA
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "$(Desc_Section03)"
!endif
!ifdef INSTALL_ACTIVEX
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "$(Desc_Section04)"
!endif
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} "$(Desc_Section05)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC06} "$(Desc_Section06)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC07} "$(Desc_Section07)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC08} "$(Desc_Section08)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;;; Start function
Function .onInit

# SetRegView 64

${MementoSectionRestore}

# !include "x64.nsh"
# ${Unless} ${RunningX64}
#    MessageBox MB_OK|MB_ICONSTOP "This version of VLC only runs on 64-bit operating systems.$\nPlease get the 32-bit version and try again."
#    Quit
# ${EndUnless}
${If} ${AtLeastWinXP}
    ${If} ${IsWinXP}
    ${AndIf} ${AtMostServicePack} 1
        Goto WinTooOld
    ${Endif}
${Else}
    Goto WinTooOld
${Endif}

ReadRegStr $INSTDIR HKLM "${PRODUCT_DIR_REGKEY}" "InstallDir"
StrCmp $INSTDIR "" 0 WinOk
StrCpy $INSTDIR "$PROGRAMFILES\VideoLAN\VLC"
Goto WinOk

WinTooOld:
    MessageBox MB_OK|MB_ICONSTOP "This version of VLC only runs on Windows XP SP2 and newer."
    Quit

WinOk:
  ; /update argument
  Call ParseCommandline

  ; See if a other bitness VLC version exists
  !ifdef VLC_64BIT_INSTALLER
    SetRegView 32

    Call ReadPreviousVersion

    ${If} $PreviousVersion != ""
      ReadRegStr $32bitUninstaller ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString"
      ReadRegStr $32bitPath ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstallLocation"
      StrCpy $PreviousVersion ""
    ${EndIf}

    SetRegView lastused
  !endif

  ; See if previous version exists
  Call ReadPreviousVersion

  ${If} $PreviousVersion == ""
    StrCpy $PerformUpdate 0
  ${Else}
    Push "${VERSION}"
    Push $PreviousVersion
    Call VersionCompare

    ${If} $PreviousVersionState != "newer"
      StrCpy $PerformUpdate 0
    ${EndIf}
  ${EndIf}

  !insertmacro MUI_LANGDLL_DISPLAY

FunctionEnd

;;; Page to upgrade / downgrade or customize the installation
Function PageReinstall
  ${If} $PreviousVersion == ""
    Abort
  ${EndIf}

  ${If} $PerformUpdate == 1
    StrCpy $ReinstallType 1
    Abort
  ${EndIf}

  nsDialogs::Create /NOUNLOAD 1018
  Pop $0

  ${If} $PreviousVersionState == "newer"

    !insertmacro MUI_HEADER_TEXT "$(Reinstall_Headline)" "$(Reinstall_HeadlineInstall)"
    nsDialogs::CreateItem /NOUNLOAD STATIC ${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS} 0 0 0 100% 40 "$(Reinstall_MessageOlder)"
    Pop $R0
    nsDialogs::CreateItem /NOUNLOAD BUTTON ${BS_AUTORADIOBUTTON}|${BS_VCENTER}|${BS_MULTILINE}|${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS}|${WS_GROUP}|${WS_TABSTOP} 0 10 55 100% 30 "$(Reinstall_OptionUpgrade)"
    Pop $ReinstallUninstallBtn
    nsDialogs::CreateItem /NOUNLOAD BUTTON ${BS_AUTORADIOBUTTON}|${BS_TOP}|${BS_MULTILINE}|${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS} 0 10 85 100% 50 "$(Reinstall_OptionAdvanced)"
    Pop $R0

    ${If} $ReinstallType == ""
      StrCpy $ReinstallType 1
    ${EndIf}

  ${ElseIf} $PreviousVersionState == "older"

    !insertmacro MUI_HEADER_TEXT "$(Reinstall_Headline)" "$(Reinstall_HeadlineInstall)"
    nsDialogs::CreateItem /NOUNLOAD STATIC ${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS} 0 0 0 100% 40 "$(Reinstall_MessageNewer)"
    Pop $R0
    nsDialogs::CreateItem /NOUNLOAD BUTTON ${BS_AUTORADIOBUTTON}|${BS_VCENTER}|${BS_MULTILINE}|${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS}|${WS_GROUP}|${WS_TABSTOP} 0 10 55 100% 30 "$(Reinstall_OptionDowngrade)"
    Pop $ReinstallUninstallBtn
    nsDialogs::CreateItem /NOUNLOAD BUTTON ${BS_AUTORADIOBUTTON}|${BS_TOP}|${BS_MULTILINE}|${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS} 0 10 85 100% 50 "$(Reinstall_OptionAdvanced)"
    Pop $R0

    ${If} $ReinstallType == ""
      StrCpy $ReinstallType 1
    ${EndIf}

  ${ElseIf} $PreviousVersionState == "same"

    !insertmacro MUI_HEADER_TEXT "$(Reinstall_Headline)" "$(Reinstall_HeadlineMaintenance)"
    nsDialogs::CreateItem /NOUNLOAD STATIC ${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS} 0 0 0 100% 40 "$(Reinstall_MessageSame)"
    Pop $R0
    nsDialogs::CreateItem /NOUNLOAD BUTTON ${BS_AUTORADIOBUTTON}|${BS_VCENTER}|${BS_MULTILINE}|${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS}|${WS_GROUP}|${WS_TABSTOP} 0 10 55 100% 30 "$(Reinstall_OptionComponents)"
    Pop $R0
    nsDialogs::CreateItem /NOUNLOAD BUTTON ${BS_AUTORADIOBUTTON}|${BS_TOP}|${BS_MULTILINE}|${WS_VISIBLE}|${WS_CHILD}|${WS_CLIPSIBLINGS} 0 10 85 100% 50 "$(Reinstall_OptionUninstall)"
    Pop $ReinstallUninstallBtn

    ${If} $ReinstallType == ""
      StrCpy $ReinstallType 2
    ${EndIf}

  ${Else}

    MessageBox MB_ICONSTOP "Unknown value of PreviousVersionState, aborting" /SD IDOK
    Abort

  ${EndIf}

  ${If} $ReinstallType == "1"
    SendMessage $ReinstallUninstallBtn ${BM_SETCHECK} 1 0
  ${Else}
    SendMessage $R0 ${BM_SETCHECK} 1 0
  ${EndIf}

  nsDialogs::Show

FunctionEnd

Function PageLeaveReinstall

  SendMessage $ReinstallUninstallBtn ${BM_GETCHECK} 0 0 $R0
  ${If} $R0 == 1
    ; Option to uninstall old version selected
    StrCpy $ReinstallType 1
  ${Else}
    ; Custom up/downgrade or add/remove/reinstall
    StrCpy $ReinstallType 2
  ${EndIf}

  ${If} $ReinstallType == 1

    ${If} $PreviousVersionState == "same"

      Call RunUninstaller
      Quit

    ${EndIf}

  ${EndIf}

FunctionEnd

Function RunUninstaller
  ReadRegStr $R1 ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString"
  ${If} $R1 == ""
    Return
  ${EndIf}

  ;Run uninstaller
  HideWindow
  ClearErrors

  ExecWait '"$R1" _?=$INSTDIR'

  IfErrors no_remove_uninstaller

  IfFileExists "$INSTDIR\uninstall.exe" 0 no_remove_uninstaller
    Delete "$R1"
    RMDir $INSTDIR

  no_remove_uninstaller:
FunctionEnd

Function PageSkipPre
  ${If} $PerformUpdate == 1
    Abort
  ${ElseIf} $PreviousVersion != ""
    Abort
  ${EndIf}
FunctionEnd

;;; Used during upgrade to skip most pages
Function PageFastUpdatePre
  ${If} $PerformUpdate == 1
    Abort
  ${EndIf}
FunctionEnd

Function PageComponentsPre
  ClearErrors
  ReadRegStr $0 ${MEMENTO_REGISTRY_ROOT} `${MEMENTO_REGISTRY_KEY}` MementoSectionUsed
  ; Backward compatibility:
  ; Don't skip the components page until Memento was able to save the user choices.
  IfErrors done

  ${If} $ReinstallType == 1
    Abort
  ${EndIf}

done:
FunctionEnd

Function PageDirectoryPre
  ${If} $ReinstallType != ""
    Abort
  ${EndIf}
FunctionEnd

Function .OnInstSuccess
    ${MementoSectionSave}
FunctionEnd

;; End function
Section -Post
  WriteUninstaller "$INSTDIR\uninstall.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "InstallDir" $INSTDIR
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "Version" "${VERSION}"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\vlc.exe"

  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "UninstallString" "$\"$INSTDIR\uninstall.exe$\""
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "InstallLocation" "$INSTDIR"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "DisplayIcon" "$INSTDIR\vlc.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "VersionMajor"  "3"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" \
    "VersionMinor" "0"
SectionEnd

;;;;;;;;;;;;;;;;;;;;;;;;
; Uninstaller sections ;
;;;;;;;;;;;;;;;;;;;;;;;;

Section "un.$(Name_Section91)" SEC91
  SectionIn 1 2 3 RO
  SetShellVarContext all

  !insertmacro MacroAllExtensions DeleteContextMenu
  !insertmacro MacroAllExtensions UnRegisterExtensionSection
  !insertmacro MacroSkinExtensions UnRegisterExtensionSection
  !insertmacro DeleteContextMenuExt "Directory"

  ;remove activex plugin
 UnRegDLL "$INSTDIR\axvlc.dll"
#  ExecWait 'regsvr32.exe /s /u "$INSTDIR\axvlc.dll"'
  Delete /REBOOTOK "$INSTDIR\axvlc.dll"

  ;remove mozilla plugin
  Push $R0
  Push $R1
  Push $R2

  !define Index 'Line${__LINE__}'
  StrCpy $R1 "0"

  "${Index}-Loop:"

    ; Check for Key
    EnumRegKey $R0 HKLM "SOFTWARE\Mozilla" "$R1"
    StrCmp $R0 "" "${Index}-End"
    IntOp $R1 $R1 + 1
    ReadRegStr $R2 HKLM "SOFTWARE\Mozilla\$R0\Extensions" "Plugins"
    StrCmp $R2 "" "${Index}-Loop" ""

    ; old files (0.8.5 and before) that may be lying around
    Delete /REBOOTOK "$R2\npvlc.dll"
    Delete /REBOOTOK "$R2\libvlc.dll"
    Delete /REBOOTOK "$R2\vlcintf.xpt"
    Goto "${Index}-Loop"

  "${Index}-End:"
  !undef Index
  Delete /REBOOTOK "$INSTDIR\npvlc.dll"

  RMDir "$SMPROGRAMS\VideoLAN"
  RMDir /r $SMPROGRAMS\VideoLAN

  FileOpen $UninstallLog "$INSTDIR\uninstall.log" r
  UninstallLoop:
    ClearErrors
    FileRead $UninstallLog $R0
    IfErrors UninstallEnd
    Push $R0
    Call un.TrimNewLines
    Pop $R0
    Delete "$INSTDIR\$R0"
    Goto UninstallLoop
  UninstallEnd:
  FileClose $UninstallLog
  Delete "$INSTDIR\uninstall.log"
  Delete "$INSTDIR\uninstall.exe"
  Push "\"
  Call un.RemoveEmptyDirs
  RMDir "$INSTDIR"

  DeleteRegKey HKLM Software\VideoLAN

  DeleteRegKey HKCR Applications\vlc.exe
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\App Paths\vlc.exe"
  DeleteRegKey HKCR AudioCD\shell\PlayWithVLC
  DeleteRegKey HKCR DVD\shell\PlayWithVLC
  DeleteRegValue HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayDVDMovieOnArrival" "VLCPlayDVDMovieOnArrival"
  DeleteRegKey HKLM Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDMovieOnArrival
  DeleteRegValue HKLM "Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayCDAudioOnArrival" "VLCPlayCDAudioOnArrival"
  DeleteRegKey HKLM Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayCDAudioOnArrival
  DeleteRegValue HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayVideoCDMovieOnArrival" "VLCPlayVCDMovieOnArrival"
  DeleteRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVCDMovieOnArrival
  DeleteRegValue HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlaySuperVideoCDMovieOnArrival" "VLCPlaySVCDMovieOnArrival"
  DeleteRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlaySVCDMovieOnArrival
  DeleteRegValue HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayDVDAudioOnArrival" "VLCPlayDVDAudioOnArrival"
  DeleteRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayDVDAudioOnArrival
  DeleteRegValue HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayVideoFilesOnArrival" "VLCPlayVideoFilesOnArrival"
  DeleteRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayVideoFilesOnArrival
  DeleteRegValue HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\EventHandlers\PlayMusicFilesOnArrival" "VLCPlayMusicFilesOnArrival"
  DeleteRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers\Handlers\VLCPlayMusicFilesOnArrival

  DeleteRegKey HKLM Software\Clients\Media\VLC
  DeleteRegValue HKLM "Software\RegisteredApplications" "VLC"
  DeleteRegKey HKCR "VLC.MediaFile"
  DeleteRegKey HKCR "VLC.DVDMovie"
  DeleteRegKey HKCR "VLC.CDAudio"
  DeleteRegKey HKCR "VLC.VCDMovie"
  DeleteRegKey HKCR "VLC.SVCDMovie"
  DeleteRegKey HKCR "VLC.OPENFolder"
  DeleteRegKey HKCR "VLC.Bluray"


  DeleteRegKey HKLM \
    "SOFTWARE\MozillaPlugins\@videolan.org/vlc,version=${VERSION}"

  DeleteRegKey HKLM \
    "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"

  Delete "$DESKTOP\VLC media player.lnk"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd

Section /o "un.$(Name_Section92)" SEC92
  !insertmacro delprefs
SectionEnd

; Uninstaller section descriptions
!insertmacro MUI_UNFUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC91} "$(Desc_Section91)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC92} "$(Desc_Section92)"
!insertmacro MUI_UNFUNCTION_DESCRIPTION_END

Function un.onInit

# SetRegView 64

  !insertmacro MUI_UNGETLANGUAGE

FunctionEnd
